#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Angler v_0_0_0Mod01.fsh  by   Chris_M_Thomasson
//https://www.shadertoy.com/view/3dffDX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666  
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Pre-Alpha Vector Field by Chris M. Thomasson ver:0.0.4
The code is basic, and the math can be streamlined.
This is a basic experiment, not thinking of sheer performance yet.

-- Removed the global array! :^)

-- Removed Create an attractor by clicking and dragging it around.
___________________________________*/


// The number of points in the spiral
#define CT_N 16


// Viewport Axes
struct ct_axes
{
    float xmin;
    float xmax;
    float ymin;
    float ymax;
};
    
    
ct_axes ct_axes_from_radius(
    in vec3 vpcircle
){
    return ct_axes(
        vpcircle.x - vpcircle.z,
        vpcircle.x + vpcircle.z,
        vpcircle.y - vpcircle.z,
        vpcircle.y + vpcircle.z
    );
}


// Simple 2d Plane
struct ct_plane2d
{
    ct_axes axes;
    float xstep;
    float ystep;
};
    
    
ct_plane2d ct_plane2d_create(
    in ct_axes axes
){
    float awidth = axes.xmax - axes.xmin;
    float aheight = axes.ymax - axes.ymin;
    
    float daspect = abs(iResolution.y / iResolution.x);
    float waspect = abs(aheight / awidth);
    
    if (daspect > waspect)
    {
        float excess = aheight * (daspect / waspect - 1.0);
        axes.ymax += excess / 2.0;
        axes.ymin -= excess / 2.0;
    }
    
    else if (daspect < waspect)
    {
        float excess = awidth * (waspect / daspect - 1.0);
        axes.xmax += excess / 2.0;
        axes.xmin -= excess / 2.0;
    }
    
    return ct_plane2d(
        axes,
        (axes.xmax - axes.xmin) / iResolution.x,
        (axes.ymax - axes.ymin) / iResolution.y
    );
}


vec2 ct_plane2d_project(
	in ct_plane2d self,
    in vec2 z
){
	return vec2(
        self.axes.xmin + z.x * self.xstep,
        self.axes.ymin + z.y * self.ystep
    );
}


// Gain a normalized vector from p, 
// using a power of npow.
vec2 ct_vfield_normal(
    in vec2 p,
    float npow
){
    vec2 g = vec2(0.0, 0.0);
    
    const int imax = CT_N;
    
    float abase = 6.28318 / float(imax);
    float rbase = 1. / float(imax);
    
    for (int i = 0; i < imax * 2; ++i)
    {
        float angle = abase * float(i);
        float radius = rbase * float(i);
        
        angle += sin(iTime * .5) * 3.1459;
       
        vec2 vp = vec2(
            cos(angle) * radius * (1. + abs(sin(iTime))), 
            sin(angle) * radius * (1. + abs(cos(iTime)))
        );
        
        float vm = -1.;
        
        vec2 dif = vp - p;
        float sum = dif[0] * dif[0] + dif[1] * dif[1];
        float mass = pow(sum, npow);
        
      	g[0] = g[0] + vm * dif[0] / mass;
      	g[1] = g[1] + vm * dif[1] / mass;
    }
    
    return normalize(g);
}


float ct_normal_pi(
    in vec2 z,
    in float sa
){
    float a = atan(z[1], z[0]) + sa;
    if (a < 0.0) a += 6.28318;
    a /= 6.28318;
    return a;
}


// Vector Pixel Iteration
vec4 ct_vpixel(
    in vec2 z,
    in vec2 c,
    in int n,
    in float npow
){
    vec2 vn = ct_vfield_normal(z, npow);
    
    float a = cos(iTime * .1) * 3.14; // Humm...
    
    float npi = ct_normal_pi(vn, a);
    
    float scale = float(CT_N);
    
    float color = mod(npi * scale, 1.0);
    
    if (color < .5)
    {
        //color /= .5;
        //return vec4(color, 0, color, 1.0);
    }
    
    return vec4(color, color, color, 1.0);
}


// High-Level Entry
vec4 ct_main(
    in ct_plane2d plane,
    in vec2 c
){  
    return ct_vpixel(c, c, 128, 2.);
}


// Raw Entry.
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    vec3 vpcircle = vec3(
        0.0, 
        0.0, 
        0.1 + abs(sin(iTime * .1)) * 4.9
    );
    
    ct_plane2d plane = ct_plane2d_create(
        ct_axes_from_radius(vpcircle)
    );
    
    vec2 c = ct_plane2d_project(plane, fragCoord);
    
    // Exec...
    vec4 color = ct_main(plane, c);
    
    fragColor = color;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

